﻿using System;

namespace VIRP.EFR.BO
{
    [Serializable]
    public class ReferralFollowUp
    {
        public int ReferralId { get; set; }
        public string StationNumber { get; set; }
        public string InstitutionName { get; set; }
        public int ContactId { get; set; }
        public int ActivityId { get; set; }
        public string PatientLastName { get; set; }
        public string PatientFirstName { get; set; }
        public string PatientMI { get; set; }
        public string FollowUpType { get; set; }
        public string Reason { get; set; }
        public DateTime? DueDate { get; set; }
        public DateTime? ReminderDate { get; set; }

        private string patientFullName;
        public string PatientFullName
        {
            get
            {
                return !string.IsNullOrEmpty(this.patientFullName) ? this.patientFullName : this.PatientLastName + ", " + this.PatientFirstName + " " + this.PatientMI;
                //return !string.IsNullOrEmpty(_patientFullName) ? _patientFullName : $"{PatientLastName}, {PatientFirstName} {PatientMI}";
            }
            set
            {
                this.patientFullName = value;
            }
        }

        private string normalizedDueDate;
        public string NormalizedDueDate
        {
            get
            {
                return !string.IsNullOrEmpty(this.normalizedDueDate) ? this.normalizedDueDate 
                    : this.DueDate.HasValue ? this.DueDate.Value.ToString("d") : string.Empty;
            }
            set
            {
                this.normalizedDueDate = value;
            }
        }

        private string normalizedReminderDate;
        public string NormalizedReminderDate
        {
            get
            {
                return !string.IsNullOrEmpty(this.normalizedReminderDate) ? this.normalizedReminderDate 
                    : this.ReminderDate.HasValue ? this.ReminderDate.Value.ToString("d") : string.Empty;
            }
            set
            {
                this.normalizedReminderDate = value;
            }
        }
    }
}
